/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.view.Gravity;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RelativeLayout
extends ViewGroup {
    public static final int LEFT_OF = 0;
    public static final int RIGHT_OF = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    public static final int ALIGN_LEFT = 4;
    public static final int ALIGN_TOP = 5;
    public static final int ALIGN_RIGHT = 6;
    public static final int ALIGN_BOTTOM = 7;
    private static final int VERB_COUNT = 8;
    private static final int[] RULES_VERTICAL = new int[]{2, 3, 5, 7};
    private static final int[] RULES_HORIZONTAL = new int[]{0, 1, 4, 6};
    private static final int VALUE_NOT_SET = Integer.MIN_VALUE;
    private int gravity = 51;
    private int ignoreGravity = -1;
    private boolean dirtyHierarchy;
    private View[] sortedHorizontalChildren;
    private View[] sortedVerticalChildren;
    private final int[] inBounds = new int[4];
    private final int[] outBounds = new int[4];
    private final DependencyGraph mGraph = new DependencyGraph();

    private void sortChildren() {
        int count = this.getChildCount();
        if (this.sortedVerticalChildren == null || this.sortedVerticalChildren.length != count) {
            this.sortedVerticalChildren = new View[count];
        }
        if (this.sortedHorizontalChildren == null || this.sortedHorizontalChildren.length != count) {
            this.sortedHorizontalChildren = new View[count];
        }
        this.mGraph.clear();
        for (int i = 0; i < count; ++i) {
            this.mGraph.add(this.getChildAt(i));
        }
        this.mGraph.getSortedViews(this.sortedVerticalChildren, RULES_VERTICAL);
        this.mGraph.getSortedViews(this.sortedHorizontalChildren, RULES_HORIZONTAL);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int i;
        int[] rules;
        LayoutParams params;
        View child2;
        if (this.dirtyHierarchy) {
            this.sortChildren();
            this.dirtyHierarchy = false;
        }
        int myWidth = -1;
        int myHeight = -1;
        int width = 0;
        int height = 0;
        MeasureSpec.Mode widthMode = MeasureSpec.getMode(widthMeasureSpec);
        MeasureSpec.Mode heightMode = MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode.isSpecified()) {
            myWidth = widthSize;
        }
        if (heightMode.isSpecified()) {
            myHeight = heightSize;
        }
        if (widthMode.isExactly()) {
            width = myWidth;
        }
        if (heightMode.isExactly()) {
            height = myHeight;
        }
        Object ignore = null;
        int gravity = this.gravity & 7;
        boolean horizontalGravity = gravity != 3 && gravity != 0;
        gravity = this.gravity & 0x70;
        boolean verticalGravity = gravity != 48 && gravity != 0;
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        boolean offsetHorizontalAxis = false;
        boolean offsetVerticalAxis = false;
        if ((horizontalGravity || verticalGravity) && this.ignoreGravity != -1) {
            ignore = this.findViewById(this.ignoreGravity);
        }
        boolean isWrapContentWidth = widthMode.isVariable();
        boolean isWrapContentHeight = heightMode.isVariable();
        for (View child2 : this.sortedHorizontalChildren) {
            if (child2.getVisibility() == 2) continue;
            params = (LayoutParams)child2.getLayoutParams();
            rules = params.rules;
            this.applyHorizontalSizeRules(params, myWidth, rules);
            this.measureChildHorizontal(child2, params, myWidth, myHeight);
            if (!this.positionChildHorizontal(child2, params, myWidth, isWrapContentWidth)) continue;
            offsetHorizontalAxis = true;
        }
        View[] views = this.sortedVerticalChildren;
        int count = views.length;
        for (i = 0; i < count; ++i) {
            child2 = views[i];
            if (child2.getVisibility() == 2) continue;
            params = (LayoutParams)child2.getLayoutParams();
            rules = params.rules;
            this.applyVerticalSizeRules(params, myHeight, rules);
            this.measureChild(child2, params, myWidth, myHeight);
            if (this.positionChildVertical(child2, params, myHeight, isWrapContentHeight)) {
                offsetVerticalAxis = true;
            }
            if (isWrapContentWidth) {
                width = Math.max(width, params.mRight + params.rightMargin);
            }
            if (isWrapContentHeight) {
                height = Math.max(height, params.mBottom + params.bottomMargin);
            }
            if (child2 != ignore || verticalGravity) {
                left = Math.min(left, params.mLeft - params.leftMargin);
                top = Math.min(top, params.mTop - params.topMargin);
            }
            if (child2 == ignore && !horizontalGravity) continue;
            right = Math.max(right, params.mRight + params.rightMargin);
            bottom = Math.max(bottom, params.mBottom + params.bottomMargin);
        }
        if (isWrapContentWidth) {
            if (this.getLayoutParams() != null && this.getLayoutParams().width >= 0) {
                width = Math.max(width, this.getLayoutParams().width);
            }
            width = Math.max(width, this.getMinWidth());
            width = RelativeLayout.resolveSize(width, widthMeasureSpec);
            if (offsetHorizontalAxis) {
                for (i = 0; i < count; ++i) {
                    child2 = views[i];
                    if (child2.getVisibility() == 2) continue;
                    params = (LayoutParams)child2.getLayoutParams();
                    int childHorizontalGravity = params.gravity & 7;
                    if (childHorizontalGravity == 1) {
                        this.centerHorizontal(child2, params, width);
                        continue;
                    }
                    if (childHorizontalGravity != 5) continue;
                    int childWidth = child2.getMeasuredWidth();
                    params.mLeft = width - childWidth;
                    params.mRight = params.mLeft + childWidth;
                }
            }
        }
        if (isWrapContentHeight) {
            if (this.getLayoutParams() != null && this.getLayoutParams().height >= 0) {
                height = Math.max(height, this.getLayoutParams().height);
            }
            height = Math.max(height, this.getMinHeight());
            height = RelativeLayout.resolveSize(height, heightMeasureSpec);
            if (offsetVerticalAxis) {
                for (i = 0; i < count; ++i) {
                    child2 = views[i];
                    if (child2.getVisibility() == 2) continue;
                    params = (LayoutParams)child2.getLayoutParams();
                    int childVerticalGravity = params.gravity & 0x70;
                    if (childVerticalGravity == 16) {
                        this.centerVertical(child2, params, height);
                        continue;
                    }
                    if (childVerticalGravity != 80) continue;
                    int childHeight = child2.getMeasuredHeight();
                    params.mTop = height - childHeight;
                    params.mBottom = params.mTop + childHeight;
                }
            }
        }
        if (horizontalGravity || verticalGravity) {
            int[] inBounds = this.inBounds;
            inBounds[0] = 0;
            inBounds[1] = 0;
            inBounds[2] = width;
            inBounds[3] = height;
            Gravity.apply(gravity, right - left, bottom - top, inBounds, 0, 0, this.outBounds);
            int horizontalOffset = this.outBounds[0] - left;
            int verticalOffset = this.outBounds[1] - top;
            if (horizontalOffset != 0 || verticalOffset != 0) {
                for (int i2 = 0; i2 < count; ++i2) {
                    View child3 = views[i2];
                    if (child3.getVisibility() == 2 || child3 == ignore) continue;
                    LayoutParams params2 = (LayoutParams)child3.getLayoutParams();
                    if (horizontalGravity) {
                        params2.mLeft += horizontalOffset;
                        params2.mRight += horizontalOffset;
                    }
                    if (!verticalGravity) continue;
                    params2.mTop += verticalOffset;
                    params2.mBottom += verticalOffset;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private void measureChild(@Nonnull View child, @Nonnull LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, myWidth);
        int childHeightMeasureSpec = this.getChildMeasureSpec(params.mTop, params.mBottom, params.height, params.topMargin, params.bottomMargin, myHeight);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private void measureChildHorizontal(@Nonnull View child, @Nonnull LayoutParams params, int myWidth, int myHeight) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, myWidth);
        if (myHeight < 0) {
            childHeightMeasureSpec = params.height >= 0 ? MeasureSpec.makeMeasureSpec(params.height, MeasureSpec.Mode.EXACTLY) : MeasureSpec.makeMeasureSpec(0, MeasureSpec.Mode.UNSPECIFIED);
        } else {
            int maxHeight = Math.max(0, myHeight);
            MeasureSpec.Mode heightMode = params.height == -1 ? MeasureSpec.Mode.EXACTLY : MeasureSpec.Mode.AT_MOST;
            childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(maxHeight, heightMode);
        }
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private int getChildMeasureSpec(int childStart, int childEnd, int childSize, int startMargin, int endMargin, int mySize) {
        boolean isUnspecified;
        MeasureSpec.Mode childSpecMode = MeasureSpec.Mode.UNSPECIFIED;
        int childSpecSize = 0;
        boolean bl = isUnspecified = mySize < 0;
        if (isUnspecified) {
            if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
                childSpecSize = Math.max(0, childEnd - childStart);
                childSpecMode = MeasureSpec.Mode.EXACTLY;
            } else if (childSize >= 0) {
                childSpecSize = childSize;
                childSpecMode = MeasureSpec.Mode.EXACTLY;
            } else {
                childSpecSize = 0;
                childSpecMode = MeasureSpec.Mode.UNSPECIFIED;
            }
            return MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
        }
        int tempStart = childStart;
        int tempEnd = childEnd;
        if (tempStart == Integer.MIN_VALUE) {
            tempStart = startMargin;
        }
        if (tempEnd == Integer.MIN_VALUE) {
            tempEnd = mySize - endMargin;
        }
        int maxAvailable = tempEnd - tempStart;
        if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
            childSpecMode = MeasureSpec.Mode.EXACTLY;
            childSpecSize = Math.max(0, maxAvailable);
        } else if (childSize >= 0) {
            childSpecMode = MeasureSpec.Mode.EXACTLY;
            childSpecSize = maxAvailable >= 0 ? Math.min(maxAvailable, childSize) : childSize;
        } else if (childSize == -1) {
            childSpecMode = MeasureSpec.Mode.EXACTLY;
            childSpecSize = Math.max(0, maxAvailable);
        } else if (childSize == -2 && maxAvailable >= 0) {
            childSpecMode = MeasureSpec.Mode.AT_MOST;
            childSpecSize = maxAvailable;
        }
        return MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
    }

    private boolean positionChildHorizontal(View child, @Nonnull LayoutParams params, int myWidth, boolean wrapContent) {
        int gravity = params.gravity;
        if (params.mLeft == Integer.MIN_VALUE && params.mRight != Integer.MIN_VALUE) {
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else if (params.mLeft != Integer.MIN_VALUE && params.mRight == Integer.MIN_VALUE) {
            params.mRight = params.mLeft + child.getMeasuredWidth();
        } else if (params.mLeft == Integer.MIN_VALUE) {
            if ((gravity & 7) == 1) {
                if (!wrapContent) {
                    this.centerHorizontal(child, params, myWidth);
                } else {
                    this.positionAtEdge(child, params, myWidth);
                }
                return true;
            }
            this.positionAtEdge(child, params, myWidth);
        }
        return (gravity & 7) == 5;
    }

    private void positionAtEdge(@Nonnull View child, @Nonnull LayoutParams params, int myWidth) {
        params.mLeft = params.leftMargin;
        params.mRight = params.mLeft + child.getMeasuredWidth();
    }

    private boolean positionChildVertical(View child, @Nonnull LayoutParams params, int myHeight, boolean wrapContent) {
        int gravity = params.gravity;
        if (params.mTop == Integer.MIN_VALUE && params.mBottom != Integer.MIN_VALUE) {
            params.mTop = params.mBottom - child.getMeasuredHeight();
        } else if (params.mTop != Integer.MIN_VALUE && params.mBottom == Integer.MIN_VALUE) {
            params.mBottom = params.mTop + child.getMeasuredHeight();
        } else if (params.mTop == Integer.MIN_VALUE) {
            if ((gravity & 0x70) == 16) {
                if (!wrapContent) {
                    this.centerVertical(child, params, myHeight);
                } else {
                    params.mTop = params.topMargin;
                    params.mBottom = params.mTop + child.getMeasuredHeight();
                }
                return true;
            }
            params.mTop = params.topMargin;
            params.mBottom = params.mTop + child.getMeasuredHeight();
        }
        return (gravity & 0x70) == 80;
    }

    private void applyHorizontalSizeRules(@Nonnull LayoutParams childParams, int myWidth, int[] rules) {
        childParams.mLeft = Integer.MIN_VALUE;
        childParams.mRight = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 0);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mLeft - (anchorParams.leftMargin + childParams.rightMargin);
        } else if (rules[0] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - childParams.rightMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 1);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mRight + (anchorParams.rightMargin + childParams.leftMargin);
        } else if (rules[1] != 0) {
            childParams.mLeft = childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 4);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mLeft + childParams.leftMargin;
        } else if (rules[4] != 0) {
            childParams.mLeft = childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 6);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mRight - childParams.rightMargin;
        } else if (rules[6] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - childParams.rightMargin;
        }
        if ((childParams.gravity & 7) == 3) {
            childParams.mLeft = childParams.leftMargin;
        }
        if ((childParams.gravity & 7) == 5 && myWidth >= 0) {
            childParams.mRight = myWidth - childParams.rightMargin;
        }
    }

    private void applyVerticalSizeRules(@Nonnull LayoutParams childParams, int myHeight, int[] rules) {
        childParams.mTop = Integer.MIN_VALUE;
        childParams.mBottom = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 2);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mTop - (anchorParams.topMargin + childParams.bottomMargin);
        } else if (rules[2] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - childParams.bottomMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 3);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mBottom + (anchorParams.bottomMargin + childParams.topMargin);
        } else if (rules[3] != 0) {
            childParams.mTop = childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 5);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mTop + childParams.topMargin;
        } else if (rules[5] != 0) {
            childParams.mTop = childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 7);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mBottom - childParams.bottomMargin;
        } else if (rules[7] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - childParams.bottomMargin;
        }
        if ((childParams.gravity & 0x70) == 48) {
            childParams.mTop = childParams.topMargin;
        }
        if ((childParams.gravity & 0x70) == 80 && myHeight >= 0) {
            childParams.mBottom = myHeight - childParams.bottomMargin;
        }
    }

    @Nullable
    private LayoutParams getRelatedViewParams(int[] rules, int relation) {
        ViewGroup.LayoutParams params;
        View v = this.getRelatedView(rules, relation);
        if (v != null && (params = v.getLayoutParams()) instanceof LayoutParams) {
            return (LayoutParams)v.getLayoutParams();
        }
        return null;
    }

    @Nullable
    private View getRelatedView(@Nonnull int[] rules, int relation) {
        int anchor = rules[relation];
        if (anchor != 0) {
            DependencyGraph.Node node = (DependencyGraph.Node)this.mGraph.keyNodes.get(anchor);
            if (node == null) {
                return null;
            }
            View v = node.view;
            while (v.getVisibility() == 2) {
                rules = ((LayoutParams)v.getLayoutParams()).rules;
                node = (DependencyGraph.Node)this.mGraph.keyNodes.get(rules[relation]);
                if (node == null || v == node.view) {
                    return null;
                }
                v = node.view;
            }
            return v;
        }
        return null;
    }

    private void centerHorizontal(@Nonnull View child, @Nonnull LayoutParams params, int myWidth) {
        int childWidth = child.getMeasuredWidth();
        int left = (myWidth - childWidth) / 2;
        params.mLeft = left;
        params.mRight = left + childWidth;
    }

    private void centerVertical(@Nonnull View child, @Nonnull LayoutParams params, int myHeight) {
        int childHeight = child.getMeasuredHeight();
        int top = (myHeight - childHeight) / 2;
        params.mTop = top;
        params.mBottom = top + childHeight;
    }

    @Override
    protected void onLayout(boolean changed) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(lp.mLeft, lp.mTop, lp.mRight, lp.mBottom);
        }
    }

    public void setIgnoreGravity(int viewId) {
        this.ignoreGravity = viewId;
    }

    public int getIgnoreGravity() {
        return this.ignoreGravity;
    }

    public void setGravity(int gravity) {
        if (this.gravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 3;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.gravity = gravity;
            this.requestLayout();
        }
    }

    public void setHorizontalGravity(int horizontalGravity) {
        if ((this.gravity & 7) != (horizontalGravity &= 7)) {
            this.gravity = this.gravity & 0xFFFFFFF8 | horizontalGravity;
            this.requestLayout();
        }
    }

    public void setVerticalGravity(int verticalGravity) {
        if ((this.gravity & 0x70) != (verticalGravity &= 0x70)) {
            this.gravity = this.gravity & 0xFFFFFF8F | verticalGravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.gravity;
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        this.dirtyHierarchy = true;
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams convertLayoutParams(@Nonnull ViewGroup.LayoutParams params) {
        if (params instanceof LayoutParams) {
            return params;
        }
        if (params instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)params);
        }
        return new LayoutParams(params);
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams createDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected boolean checkLayoutParams(@Nullable ViewGroup.LayoutParams params) {
        return params instanceof LayoutParams;
    }

    private static class DependencyGraph {
        private final List<Node> nodes = new ObjectArrayList();
        private final Int2ObjectMap<Node> keyNodes = new Int2ObjectArrayMap();
        private final Deque<Node> roots = new ArrayDeque<Node>();

        private DependencyGraph() {
        }

        void clear() {
            this.nodes.clear();
            this.keyNodes.clear();
            this.roots.clear();
        }

        void add(@Nonnull View view) {
            int id = view.getId();
            Node node = new Node();
            node.view = view;
            if (id != -1) {
                this.keyNodes.put(id, (Object)node);
            }
            this.nodes.add(node);
        }

        void getSortedViews(View[] sorted, int ... rules) {
            Node node;
            Deque<Node> roots = this.findRoots(rules);
            int index = 0;
            while ((node = roots.pollLast()) != null) {
                View view = node.view;
                int viewId = view.getId();
                sorted[index++] = view;
                for (Node dependent : node.dependents) {
                    Int2ObjectMap<Node> dependencies = dependent.dependencies;
                    dependencies.remove(viewId);
                    if (!dependencies.isEmpty()) continue;
                    roots.add(dependent);
                }
            }
            if (index < sorted.length) {
                throw new IllegalStateException("Circular dependencies cannot exist in RelativeLayout");
            }
        }

        @Nonnull
        private Deque<Node> findRoots(int[] rulesFilter) {
            for (Node node : this.nodes) {
                node.dependents.clear();
                node.dependencies.clear();
            }
            for (Node node : this.nodes) {
                LayoutParams layoutParams = (LayoutParams)node.view.getLayoutParams();
                for (int verb : rulesFilter) {
                    Node dependency;
                    int anchorViewId = layoutParams.getRule(verb);
                    if (anchorViewId <= 0 || (dependency = (Node)this.keyNodes.get(anchorViewId)) == null || dependency == node) continue;
                    dependency.dependents.add(node);
                    node.dependencies.put(anchorViewId, (Object)dependency);
                }
            }
            this.roots.clear();
            for (Node node : this.nodes) {
                if (!node.dependencies.isEmpty()) continue;
                this.roots.addLast(node);
            }
            return this.roots;
        }

        static class Node {
            View view;
            final List<Node> dependents = new ObjectArrayList();
            final Int2ObjectMap<Node> dependencies = new Int2ObjectArrayMap();

            Node() {
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private final int[] rules = new int[8];
        public int gravity = 0;
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(@Nonnull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@Nonnull ViewGroup.LayoutParams source) {
            super(source);
        }

        public void setRule(int verb, int anchor) {
            this.rules[verb] = anchor;
        }

        public int getRule(int verb) {
            return this.rules[verb];
        }

        public LayoutParams(@Nonnull LayoutParams source) {
            super(source);
            System.arraycopy(source.rules, 0, this.rules, 0, 8);
            this.gravity = source.gravity;
        }

        @Override
        @Nonnull
        public LayoutParams copy() {
            return new LayoutParams(this);
        }
    }
}

